import 'package:flutter/material.dart';
import 'package:remixicon_updated/remixicon_updated.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:admin_desktop/presentation/styles/style.dart';

class SelectFilterButton extends StatelessWidget {
  final String title;

  const SelectFilterButton({
    super.key,
    required this.title,
  });

  @override
  Widget build(BuildContext context) {
    return InkWell(
      onTap: () {},
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Text(
            title,
            style: Style.interNormal(
              size: 14,
              color: Style.black,
              letterSpacing: -14 * 0.02,
            ),
          ),
          Icon(
            Remix.arrow_down_s_line,
            size: 20.r,
            color: Style.black,
          ),
        ],
      ),
    );
  }
}
